
clear
set more off

*cd "N:\Private"
cd "C:\Data\SkyDrive\Dataset\2004-2005 Deliberative Polling\January_2004\data\"
*use "dp10formatted2.dta", clear
use "dp10rawdata.dta", clear

*drop non-participant sample
drop if samp!=2

*======================================================
*generate wave indicator variable
*======================================================
gen wave = 1

*======================================================
*create site dummies with Kearney as reference category
*======================================================

rename city sitetemp
gen site = sitetemp
drop sitetemp
recode site (3=2) (4=3) (5=4) (6=5) (7=6) (8=7) (9=8) (10=9) (11=10)

gen sitedum1=0
gen sitedum2=0
gen sitedum3=0
gen sitedum4=0
gen sitedum5=0
gen sitedum6=0
gen sitedum7=0
gen sitedum8=0
gen sitedum9=0
gen sitedum10=0
gen sitedum11=0
gen sitedum12=0
gen sitedum13=0
gen sitedum14=0
gen sitedum15=0
gen sitedum16=0
gen sitedum17=0
gen sitedum18=0
gen sitedum19=0
gen sitedum20=0
gen sitedum21=0
gen sitedum22=0
gen sitedum23=0
gen sitedum24=0
gen sitedum25=0
gen sitedum26=0
gen sitedum27=0

replace sitedum1=1 if site==1
replace sitedum2=1 if site==2
replace sitedum3=1 if site==3
replace sitedum4=1 if site==4
replace sitedum5=1 if site==5
replace sitedum6=1 if site==6
replace sitedum7=1 if site==7
replace sitedum8=1 if site==8
replace sitedum9=1 if site==9
replace sitedum10=1 if site==10

gen sitegroup=site*100+group


*======================================================
*INDIVIDUAL-LEVEL INDEPENDENT VARIABLES
*======================================================

*Female*
gen female=sex
recode female (5=1) (1=0) (9=.)
drop if female>1

*Age* rearrange to have same format as October
gen dum = age
drop age
gen age = dum
drop dum

*Young people*
gen young = age<40
drop if young>1

*Education*
gen education = educ5

*College*
gen college = education>3
drop if college>1

*NoCollege*
gen nocollege = 1-college

*White*
gen white=race
recode white (2/7=0) (98/.=.)
drop if white>1

*Black*
gen black=race
recode black (1=0) (2=1) (3/7=0)

*Nonwhite*
gen nonwhite=1-white

*Democract*
gen democrat=prtyid_a
recode democrat (3/7=0) (8/.=.)

*Republican*
gen republican=prtyid_a
recode republican (1=0) (3=1) (5/7=0)  (8/.=.)

/* ==============================================================================================*/
/* ==============================================================================================*/
/* GROUP COMPOSITION */
/* female (prop_female / n_female / presence_female)*/
/* age (av_age)*/
/* young (prop_young / n_young / presence_young) */
/* whites (prop_white / n_white / presence_white)*/
/* nonwhites (prop_nonwhite / n_nonwhite / presence_nonwhite)*/
/* blacks (prop_black / n_black / presence_black)*/
/* college (prop_college / n_college / presence_college)*/
/* nocollege (prop_nocollege / n_nocollege / presence_nocollege)*/
/* education (av_edu)*/
/* democrats (prop_democrat / n_democrat / presence_democrat)*/
/* republican (prop_republican / n_republican / presence_republican)*/
/* ==============================================================================================*/
/* ==============================================================================================*/

set more off

drop if group== .

sort site group

*sequence of people in the group*
*also counts the number of people in each group*
by site group: egen counter = seq()

gen n_female = .
gen av_age = .
gen n_young = .
gen n_white = .
gen n_nonwhite = .
gen n_black = .
gen n_college = .
gen n_nocollege = .
gen av_edu = .
gen n_democrat = .
gen n_republican = .

sum counter	/*sum = summarize, not summation*/
scalar end = r(max)	/*gets the largest number of people across groups*/

local i = 1
while `i' < scalar(end)+1 {

gen tempfemale = 1 if female==1
gen tempage = age
gen tempyoung = 1 if young==1
gen tempwhite = 1 if white==1
gen tempnonwhite = 1 if nonwhite==1
gen tempblack = 1 if black==1
gen tempcollege = 1 if college==1
gen tempnocollege = 1 if nocollege==1
gen tempedu = education
gen tempdem = 1 if democrat==1
gen temprep = 1 if republican==1

replace tempfemale = . if counter==`i'	/*discount self*/
replace tempage = . if counter==`i' 	/*discount self*/
replace tempyoung = . if counter==`i'	/*discount self*/
replace tempwhite = . if counter==`i'	/*discount self*/
replace tempnonwhite = . if counter==`i'	/*discount self*/
replace tempblack = . if counter==`i'	/*discount self*/
replace tempcollege = . if counter==`i'	/*discount self*/
replace tempnocollege = . if counter==`i'	/*discount self*/
replace tempedu = . if counter==`i'	/*discount self*/
replace tempdem = . if counter==`i'	/*discount self*/
replace temprep = . if counter==`i'	/*discount self*/

by site group: egen samplefemale = count(tempfemale)
by site group: egen sampleage = mean(tempage)
by site group: egen sampleyoung = count(tempyoung)
by site group: egen samplewhite = count(tempwhite)
by site group: egen samplenonwhite = count(tempnonwhite)
by site group: egen sampleblack = count(tempblack)
by site group: egen samplecollege = count(tempcollege)
by site group: egen samplenocollege = count(tempnocollege)
by site group: egen sampleedu = mean(tempedu)
by site group: egen sampledem = count(tempdem)
by site group: egen samplerep = count(temprep)

replace n_female = samplefemale if counter==`i'
replace av_age = sampleage if counter==`i'
replace n_young = sampleyoung if counter==`i'
replace n_white = samplewhite if counter==`i'
replace n_nonwhite = samplenonwhite if counter==`i'
replace n_black = sampleblack if counter==`i'
replace n_college = samplecollege if counter==`i'
replace n_nocollege = samplenocollege if counter==`i'
replace av_edu = sampleedu if counter==`i'
replace n_democrat = sampledem if counter==`i'
replace n_republican = samplerep if counter==`i'

drop temp* sample*

local i = `i'+1
}

*generate proportion variables*
bysort site group: egen grp_size = count(counter)
replace grp_size = grp_size-1
gen prop_female = n_female/grp_size
gen prop_young = n_young/grp_size
gen prop_white = n_white/grp_size
gen prop_nonwhite = n_nonwhite/grp_size
gen prop_black = n_black/grp_size
gen prop_college = n_college/grp_size
gen prop_nocollege = n_nocollege/grp_size
gen prop_democrat = n_dem/grp_size
gen prop_republican = n_rep/grp_size

*generate presence variables
gen presence_female = n_female>0
gen presence_white = n_white>0
gen presence_nonwhite = n_nonwhite>0
gen presence_black = n_black>0
gen presence_college = n_college>0
gen presence_nocollege = n_nocollege>0
gen presence_democrat = n_democrat>0
gen presence_republican = n_republican>0

scalar drop _all
drop counter


/* =============================================================================*/
/* DEPENDENT VARIABLES*/
/* =============================================================================*/

*individual-level*
gen dv_whole = qeval1
gen dv_large_group = qeval2
gen dv_offsession = qeval3
gen dv_small_group = qeval4
recode dv_whole dv_large_group dv_offsession dv_small_group (0=.) (11/.=.)
gen dv_respect = qeval11
gen dv_efficacy = qeval12
recode dv_respect dv_efficacy (0=.) (5/.=.)
gen dv_general = (dv_whole + dv_offsession + dv_small_group)/3

/*all mod variables are coded so that higher score reflects better moderator*/
/*That is, encouraging participation, not influencing participant, not pursuing consensus*/
gen mod_participation = qeval5
gen mod_influence = qeval6
gen mod_pursueagreement = qeval7
recode mod_* (6/.=.)
recode mod_participation (1=5) (2=4) (4=2) (5=1)

*======================================================
*drop unused variables
*======================================================
drop caseid-qrace4

cd "C:\Data\Dropbox\Research\2014- Deliberative Polling\Analysis\Replication"
save "04JanuaryToJoin.dta"
